/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.circuit.component;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentHarvestContext;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;

public abstract class CircuitComponent {
    public static final AABB FULL_BLOCK = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private final ComponentType type;
    private final ComponentContext context;

    protected CircuitComponent(ComponentType type, ComponentContext context) {
        this.type = type;
        this.context = context;
    }

    @Deprecated
    public CircuitComponent copyRotated(ComponentContext context, Rotation rotation) {
        return null;
    }

    public ComponentState getState() {
        return this.type.getDefaultState();
    }

    public AABB getBoundingBox() {
        return FULL_BLOCK;
    }

    public abstract ItemStack getPickedItem();

    public List<ItemStack> getDrops(ServerLevel level, boolean isCreative) {
        if (isCreative) {
            return Collections.emptyList();
        }
        ResourceLocation path = this.getType().getLootTable();
        LootTable table = level.m_142572_().m_129898_().m_79217_(path);
        LootContext context = new LootContext.Builder(level).m_78975_(LootContextParamSets.f_81410_);
        return table.m_79129_(context);
    }

    @Nullable
    public <T> T getInterface(VecDirection side, Class<T> type) {
        return null;
    }

    public void onAdded() {
    }

    public void beforeRemove() {
    }

    public void update(ComponentEventMap events, boolean tick) {
    }

    public void updateSequential() {
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        return InteractionResult.PASS;
    }

    public boolean isTopSolid() {
        return false;
    }

    public void spawnDrops(ComponentHarvestContext context) {
        this.getDrops(context.getLevel(), context.isCreative()).forEach(context::drop);
    }

    public void harvest(ComponentHarvestContext context) {
        this.spawnDrops(context);
        this.removeComponentAt(Vec3i.f_123288_, this.getType().getSlot(), true);
    }

    public void receiveEvent(VecDirection side, CircuitEvent event, ComponentEventMap.Builder builder) {
        builder.add(side, event);
    }

    public CompoundTag save(CompoundTag tag) {
        return tag;
    }

    public void load(CompoundTag tag) {
    }

    public final ComponentType getType() {
        return this.type;
    }

    protected final void updateExternalState(boolean reRender, Runnable action) {
        this.context.updateExternalState(reRender, action);
    }

    protected final void scheduleSequential() {
        this.context.scheduleSequential();
    }

    protected final void scheduleTick(int delay) {
        this.context.scheduleTick(delay);
    }

    protected final void sendEvent(CircuitEvent event, VecDirection ... directions) {
        this.sendEvent(event, VecDirectionFlags.of(directions));
    }

    protected final void sendEvent(CircuitEvent event, VecDirectionFlags directions) {
        this.sendEventAt(Vec3i.f_123288_, event, directions);
    }

    protected final void sendEventAt(Vec3i offset, CircuitEvent event, VecDirectionFlags directions) {
        this.context.sendEventAt(offset, this.getType().getSlot(), event, directions);
    }

    protected final void removeComponentAt(Vec3i offset, ComponentSlot slot, boolean notifyNeighbors) {
        this.context.removeComponentAt(offset, slot, notifyNeighbors);
    }

    protected final void scheduleRemoval() {
        this.context.scheduleRemoval();
    }

    protected final void playSound(SoundEvent sound, SoundSource source, float volume, float pitch) {
        this.context.playSound(sound, source, volume, pitch);
    }

    protected final boolean isValidPosition(Vec3i offset) {
        return this.context.isValidPosition(offset);
    }

    protected final boolean isTopSolid(Vec3i offset) {
        return this.context.isTopSolid(offset);
    }

    @Nullable
    protected final CircuitComponent getComponentAt(Vec3i offset, ComponentSlot slot) {
        return this.context.getComponentAt(offset, slot);
    }

    @Nullable
    protected final CircuitComponent getSibling(ComponentSlot slot) {
        return this.getComponentAt(Vec3i.f_123288_, slot);
    }

    @Nullable
    protected final CircuitComponent getNeighbor(VecDirection direction, ComponentSlot slot) {
        return this.getComponentAt(direction.getOffset(), slot);
    }
}

